package gov.va.vinci.dart.db;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.RequestStatus;
import gov.va.vinci.dart.biz.ResearchStudy;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Date;
import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestDartRequestDAO extends BusinessIntegrationTest {
	
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {
		
		Request req = DartObjectFactory.getInstance().getDartRequestDAO().findById(-1);
		Assert.assertNull(req);
	}

	@Test
	public void testTwo() throws Exception {
		
		DartRequest req = DartObjectFactory.getInstance().getDartRequestDAO().findById(1);
		Assert.assertNotNull(req);
		
		Person requestor = req.getRequestor();
		Assert.assertNotNull(requestor);
		Assert.assertTrue(requestor.getId() > 0);

		List<DartRequest> reqlist = DartObjectFactory.getInstance().getDartRequestDAO().listByName(requestor.getId(), "e");
		Assert.assertNotNull(reqlist);
	}

	@Test
	public void testThree() throws Exception {

		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		ResearchStudy activity = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		
		// create request 1 so we'll have something to work with
		DartRequest req = DartRequest.create("test request 1", new Date(), new Date(), pers, activity, "DNS");

		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		
		DartRequest req2 = DartObjectFactory.getInstance().getDartRequestDAO().findById(req.getId());
		Assert.assertNotNull(req2);
		Assert.assertEquals(req2, req);
	}

	@Test
	public void testFour() throws Exception {

		DartRequest req = DartObjectFactory.getInstance().getDartRequestDAO().findById(1);
		Assert.assertNotNull(req);
		
		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);
		Assert.assertTrue(reqList.contains(req));
	}

	@Test
	public void testFive() throws Exception {

		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		ResearchStudy activity = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		
		// create request 1 so we'll have something to work with
		DartRequest req = DartRequest.create("test request 1", new Date(), new Date(), pers, activity, "DNS");

		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		Assert.assertEquals(req.getActivity(), activity);
		
		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listByActivityId(activity.getId());
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);
		Assert.assertTrue(reqList.contains(req));
	}

	@Test
	public void testSix() throws Exception {

		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		ResearchStudy activity = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		
		// create request 1 so we'll have something to work with
		DartRequest req = DartRequest.create("test request 1", new Date(), new Date(), pers, activity, "DNS");

		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		Assert.assertEquals(req.getActivity(), activity);
		
		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listByRequestor(pers.getId());
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);
		Assert.assertTrue(reqList.contains(req));
	}

	@Test
	public void testSeven() throws Exception {

		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		ResearchStudy activity = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		
		// create request 1 so we'll have something to work with
		DartRequest req = DartRequest.create("test request 1", new Date(), new Date(), pers, activity, "DNS");

		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		Assert.assertEquals(req.getActivity(), activity);
		
		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listRecentByRequestor(pers.getId(), 100);
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);
		Assert.assertTrue(reqList.contains(req));
	}

	@Test
	public void testEight() throws Exception {

		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		ResearchStudy activity = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);

		Assert.assertNotNull(pers);
		Assert.assertNotNull(pers.getName());
		Assert.assertTrue(pers.getName().length() > 0);
		
		// create request 1 so we'll have something to work with
		DartRequest req = DartRequest.create("test request 1", new Date(), new Date(), pers, activity, "DNS");

		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		Assert.assertEquals(req.getActivity(), activity);
		
		DartRequest amendment = DartObjectFactory.getInstance().getDartRequestDAO().findMostRecentAmendment(req.getId());
		Assert.assertNull(amendment);
		
		req.approve(null, pers.getName());
		
		// now how do you propose to test when it has an amendment?
	}

	@Test
	public void testNine() throws Exception {

		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		ResearchStudy activity = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		
		// create request 1 so we'll have something to work with
		DartRequest req = DartRequest.create("test request 1", new Date(), new Date(), pers, activity, "DNS");

		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		Assert.assertEquals(req.getActivity(), activity);
		
		// need to submit that request to guarantee there is something to see in the list
		req.submit(pers.getName()); 

		Assert.assertEquals(req.getStatus(), RequestStatus.SUBMITTED);
		
		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAllButInitiated();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.contains(req));

		reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAllSubmitted();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.contains(req));

	}

}
